<?php

/**
 * This is the model class for table "Admin".
 *
 * The followings are the available columns in table 'Admin':
 * @property double $id
 * @property string $imie
 * @property string $nazwisko
 * @property string $login
 * @property string $haslo
 * @property string $rodzaj
 * @property string $email
 * @property string $telefon
 * @property string $idSzkoly
 * @property string $kodDoOdzyskaniaHasla
 * @property string $czasTestowejLekcji
 */
class Admin extends CActiveRecord
{
	const ADMIN_TYPE_TEACHER = 1;
	const ADMIN_TYPE_ADMIN = 1;
	const ADMIN_TYPE_SCHOOL_ADMIN = 3;

	public $hasloPowtorzone;
	public $schoolName;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Admin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Admin';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('hasloPowtorzone,haslo,login,idSzkoly,schoolName', 'safe'),
			array('imie, nazwisko', 'length', 'max'=>64),
			array('rodzaj', 'length', 'max'=>1),
			array('email', 'length', 'max'=>508),
			array('email', 'email'),
			array('email', 'unique'),
			array('telefon', 'length', 'max'=>32),

			array('imie, nazwisko, login, email', 'required'),
			array('login', 'unique'),

			array('haslo, hasloPowtorzone', 'required', 'on' => 'insert, isTeacher, isSchoolAdmin'),
			array('idSzkoly', 'required', 'on' => 'isTeacher, isTeacherUpdate, isSchoolAdmin'),

			array('haslo', 'compare', 'compareAttribute'=>'hasloPowtorzone',
				'message'=>'Hasło musi być powtórzone dokładnie', 'allowEmpty' => true),

			array('id, imie, nazwisko, login, haslo, rodzaj, email, telefon, schoolName', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'klasy'=>array(self::MANY_MANY, 'Klasa', 'AdminKlasy(idAdmina, idKlasy)','condition'=>'"czyTestowa" != 1'),
			'klasyZTestowa'=>array(self::MANY_MANY, 'Klasa', 'AdminKlasy(idAdmina, idKlasy)', 'condition' => '("czyTestowa" = 0 OR "czyTestowa" = 1 AND "klasyZTestowa"."id" = (SELECT MAX("id") FROM "Klasa" LEFT JOIN "AdminKlasy" ON "AdminKlasy"."idKlasy" = "Klasa"."id" WHERE "AdminKlasy"."idAdmina" = :adminId AND "Klasa"."czyTestowa" = 1))', 'params'=>array(':adminId'=>Yii::app()->user->id)),
			'testowaKlasa'=>array(self::MANY_MANY, 'Klasa', 'AdminKlasy(idAdmina, idKlasy)', 'condition'=>'"testowaKlasa"."czyTestowa"=1 and rownum<=1', 'order'=>'"testowaKlasa"."id" DESC'),
			'szkola'=>array(self::BELONGS_TO, 'Szkola', 'idSzkoly'),
			'iloscKlas'=>array(self::STAT, 'Klasa', 'AdminKlasy(idAdmina, idKlasy)'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Admin', 'ID'),
			'Imię'=>Yii::t('Admin', 'Imię'),
			'Nazwisko'=>Yii::t('Admin', 'Nazwisko'),
			'Login'=>Yii::t('Admin', 'Login'),
			'Haslo'=>Yii::t('Admin', 'Hasło'),
			'Powtórz haslo'=>Yii::t('Admin', 'Powtórz hasło'),
			'rodzaj'=>Yii::t('Admin', 'Rodzaj'),
			'E-mail'=>Yii::t('Admin', 'E-mail'),
			'Telefon'=>Yii::t('Admin', 'Telefon'),
			'idSzkoly'=>Yii::t('Admin', 'Szkoła'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->with = array('szkola');

		$db = Yii::app()->db;
		$criteria->compare($db->quoteTableName('t').'.'.$db->quoteColumnName('id'), $this->id);
		$criteria->compare('LOWER('.$db->quoteColumnName("imie").')', strtolower($this->imie), true);
		$criteria->compare('LOWER('.$db->quoteColumnName("nazwisko").')', strtolower($this->nazwisko), true);
		$criteria->compare('LOWER('.$db->quoteColumnName("login").')', strtolower($this->login), true);
		$criteria->compare('LOWER('.$db->quoteColumnName("haslo").')', strtolower($this->haslo), true);
		$criteria->compare('LOWER('.$db->quoteColumnName("email").')', strtolower($this->email), true);
		$criteria->compare('LOWER('.$db->quoteColumnName("telefon").')', strtolower($this->telefon), true);

		if($this->scenario == 'isTeacher')
			$criteria->compare($db->quoteTableName('t').'.'.$db->quoteColumnName('rodzaj'), 1);
		elseif($this->scenario == 'isSchoolAdmin')
			$criteria->compare($db->quoteTableName('t').'.'.$db->quoteColumnName('rodzaj'), self::ADMIN_TYPE_SCHOOL_ADMIN);
		else
			$criteria->compare($db->quoteTableName('t').'.'.$db->quoteColumnName('rodzaj'), 0);

		if($this->scenario=='isTeacher')
		{
			$criteria->compare('LOWER('.$db->quoteTableName('szkola').'.'.$db->quoteColumnName('nazwa').')', strtolower($this->schoolName), true);
		}

		$schoolid = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolid)) {
			$criteria->compare ($db->quoteTableName('t').'.'.$db->quoteColumnName('idSzkoly'), Yii::app()->user->getState('schoolId'));
		}

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function getDocumentsToAccept()
	{
		$sql = 'SELECT t."idKlasy"
				FROM "AdminKlasy" t
				WHERE t."idAdmina" = :idAdmina';

		$params = array(
			':idAdmina'=>Yii::app()->user->id,
		);

		$classes = Yii::app()->db->createCommand($sql)->queryColumn($params);

		if(count($classes))
		{
			$sql = 'FROM "Uzytkownik" t
				LEFT JOIN "FormularzUzytkownika" t2 ON t."id" = t2."idUzytkownika"
				LEFT JOIN "Firma" t3 ON t."idFirmy" = t3."id"
				LEFT JOIN "Formularz" t5 ON t2."idFormularza" = t5."id"
				WHERE t."idKlasy" IN ('.implode(', ', $classes).') AND t2."status" IN (:s1, :s2)
				ORDER BY t2."dataModyfikacji"';

			$params = array(
				':s1' => FormularzUzytkownika::STATUS_FILLED,
				':s2' => FormularzUzytkownika::STATUS_REFUSED,
			);

			$totalItemsCount = Yii::app()->db->createCommand('SELECT count(*) ' . $sql)->queryScalar($params);

			$sql = 'SELECT t."imie", t."nazwisko", t2."id" as "id", t3."id" as "idFirmy", t3."nazwa" as "nazwaFirmy",
				t5."nazwa" as "nazwaFormularza", t2."dataModyfikacji", t2."status" ' . $sql;

			return new CSqlDataProvider($sql, array(
				'totalItemCount' => $totalItemsCount,
				'params' => $params,
				'sort' => array(
					'attributes' => array(
						'"nazwaFirmy"', '"dataModyfikacji"'
					),
				),
				'pagination' => array(
					'pageSize' => 10,
				)
			));
		}
		else
			return new CArrayDataProvider(array(), array(
				'totalItemCount'=>0,
				'sort'=>array(
					'attributes'=>array(
						'"nazwaFirmy"', '"dataModyfikacji"'
					),
				),
				'pagination'=>array(
					'pageSize'=>10,
				),
			));
	}
}
